import { ProductsService } from './products.service';
import { CreateProductDto, UpdateProductDto, ProductResponseDto } from './dto';
import { ProductQueryDto } from './dto/product-query.dto';
export declare class ProductsController {
    private readonly productsService;
    constructor(productsService: ProductsService);
    create(req: any, createProductDto: CreateProductDto): Promise<ProductResponseDto>;
    findAll(query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getFeaturedProducts(limit?: number): Promise<ProductResponseDto[]>;
    searchProducts(searchTerm: string, limit?: number): Promise<ProductResponseDto[]>;
    getLowStockProducts(threshold?: number): Promise<ProductResponseDto[]>;
    getProductsByCategory(categoryId: number, query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getProductsByVendor(vendorId: string, query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getProductStats(): Promise<{
        totalProducts: number;
        totalInStock: number;
        totalOutOfStock: number;
        featuredProducts: number;
        categoryStats: any[];
        vendorStats: any[];
    }>;
    findOne(id: number): Promise<ProductResponseDto>;
    update(id: number, req: any, updateProductDto: UpdateProductDto): Promise<ProductResponseDto>;
    remove(id: number, req: any): Promise<void>;
    updateStock(id: number, quantity: number, operation?: 'increase' | 'decrease'): Promise<ProductResponseDto>;
    toggleFeatured(id: number): Promise<ProductResponseDto>;
}
